<?php
defined( 'ABSPATH' ) || exit;

/**
 * Plugin installation and activation for WordPress themes
 */
if ( ! class_exists( 'Medizin_Register_Plugins' ) ) {
	class Medizin_Register_Plugins {

		const GOOGLE_DRIVER_API = 'AIzaSyDXOs0Bxx-uBEA4fH4fzgoHtl64g0RWv-g';

		protected static $instance = null;

		public static function instance() {
			if ( null === self::$instance ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		function initialize() {
			add_filter( 'insight_core_tgm_plugins', array( $this, 'register_required_plugins' ) );
		}

		public function register_required_plugins( $plugins ) {
			/*
			 * Array of plugin arrays. Required keys are name and slug.
			 * If the source is NOT from the .org repo, then source is also required.
			 */
			$new_plugins = array(
				array(
					'name'     => esc_html__( 'Insight Core', 'medizin' ),
					'slug'     => 'insight-core',
					'source'   => $this->get_plugin_google_driver_url( '1trtABaj0Vozbu6I666yaHWDo1qvABOZS' ),
					'version'  => '2.7.1',
					'required' => true,
				),
				array(
					'name'     => esc_html__( 'Elementor', 'medizin' ),
					'slug'     => 'elementor',
					'required' => true,
				),
				array(
					'name'        => esc_html__( 'ThemeMove Addons For Elementor', 'medizin' ),
					'description' => 'Additional functions for Elementor',
					'slug'        => 'tm-addons-for-elementor',
					'source'      => $this->get_plugin_google_driver_url( '1QAfYhzCC_Fi75pOE6AdfMbDuI4JYhbgq' ),
					'version'     => '2.0.0',
					'required'    => true,
				),
				array(
					'name'    => esc_html__( 'Revolution Slider', 'medizin' ),
					'slug'    => 'revslider',
					'source'  => $this->get_plugin_google_driver_url( '18Cq5rBYAPQs1u0F468e8YYpKMGDnK1g0' ),
					'version' => '6.7.20',
				),
				array(
					'name' => esc_html__( 'Contact Form 7', 'medizin' ),
					'slug' => 'contact-form-7',
				),
				array(
					'name' => esc_html__( 'MailChimp for WordPress', 'medizin' ),
					'slug' => 'mailchimp-for-wp',
				),
				array(
					'name' => esc_html__( 'WooCommerce', 'medizin' ),
					'slug' => 'woocommerce',
				),
				array(
					'name'    => esc_html__( 'Insight Swatches', 'medizin' ),
					'slug'    => 'insight-swatches',
					'source'  => 'https://www.dropbox.com/scl/fi/j2po0jzzlb8zs4b5t7zu4/insight-swatches-1.7.0.zip?rlkey=1st3r1s1w3w43fbyrek90df75&dl=1',
					'version' => '1.7.0',
				),
				array(
					'name'    => esc_html__( 'WooCommerce Brands Pro', 'medizin' ),
					'slug'    => 'woo-brand',
					'source'  => 'https://www.dropbox.com/s/9rysk710yz9jxmy/woo-brand-4.5.0.zip?dl=1',
					'version' => '4.5.0',
				),
				array(
					'name' => esc_html__( 'WPC Smart Compare for WooCommerce', 'medizin' ),
					'slug' => 'woo-smart-compare',
				),
				array(
					'name' => esc_html__( 'WPC Smart Wishlist for WooCommerce', 'medizin' ),
					'slug' => 'woo-smart-wishlist',
				),
				array(
					'name' => esc_html__( 'WP-PostViews', 'medizin' ),
					'slug' => 'wp-postviews',
				),
				array(
					'name'    => esc_html__( 'Instagram Feed', 'medizin' ),
					'slug'    => 'elfsight-instagram-feed-cc',
					'source'  => 'https://www.dropbox.com/s/o55sjvh8fs2nmoq/elfsight-instagram-feed-cc-4.0.3.zip?dl=1',
					'version' => '4.0.3',
				),
			);

			$plugins = array_merge( $plugins, $new_plugins );

			return $plugins;
		}

		public function get_plugin_google_driver_url( $file_id ) {
			return "https://www.googleapis.com/drive/v3/files/{$file_id}?alt=media&key=" . self::GOOGLE_DRIVER_API;
		}
	}

	Medizin_Register_Plugins::instance()->initialize();
}
