<?php
/**
 * The Template for displaying all single products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see           https://woocommerce.com/document/template-structure/
 * @author        WooThemes
 * @package       WooCommerce/Templates
 * @version       1.6.4
 */

defined( 'ABSPATH' ) || exit;

get_header( 'shop' );
?>
	<div id="page-content" class="page-content">
		<div class="container">
			<div class="row">

				<?php Medizin_Templates::render_sidebar( 'left' ); ?>

				<div class="page-main-content">
					<?php while ( have_posts() ) : the_post(); ?>

						<?php wc_get_template_part( 'content', 'single-product' ); ?>

					<?php endwhile; ?>
				</div>

				<?php Medizin_Templates::render_sidebar( 'right' ); ?>

			</div>
		</div>
		<div class="entry-after-product">
			<div class="container">
				<div class="row">
					<div class="col-md-12">
						<?php do_action( 'woocommerce_after_single_product' ); ?>
					</div>
				</div>
			</div>
		</div>
	</div>
<?php
get_footer( 'shop' );

